﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Handel.Config" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Collections.ObjectModel" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Stany magazynowe</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<script runat="server">	   
	 
        public class Rekord {
            readonly string magazyn;
            readonly Towar towar;

            public Rekord(string magazyn, Quantity stan, decimal wartość, Towar towar) {
                this.magazyn = magazyn;
                this.stan = stan;
                this.wartość = wartość;
                this.towar = towar;
            }

            public string Magazyn {
                get { return magazyn; }
            }

            private string kod = "";

            public string Kod {
                get { return kod; }
                set { kod = value; }
            }

            private string nazwa = "";

            public string Nazwa {
                get { return nazwa; }
                set { nazwa = value; }
            }

            private Quantity stan;

            public Quantity Stan {
                get { return stan; }
            }

            private decimal wartość;

            public decimal Wartość {
                get { return wartość; }
            }

            public int lp;

            public string LP {
                get { return lp==0 ? "" : lp.ToString(); }
            }

            public Towar Towar {
                get { return towar; }
            }

            public Currency CenaSrednia {
                get {

                    decimal st = Wartość;
                    double il = Stan.Value;
                    decimal d = 0;
                    if (il != 0 && Stan != Quantity.Zero)
                    {
                        d = st / (decimal)il;
                    }
                    Currency c = new Currency(d);                    
                    return c;
                }
            }

            public string CenaSredniaStr {
                get {
                    return CenaSrednia.ToString();                        
                }
            }
        }  
	 
        ArrayList magazyny;
        StanMagazynuWorker smw;
        int licznik;
	    
        double _StanRazem;
        decimal _WartośćRazem;
        ObrotyParams obrotyParams;
        
        protected void dc_ContextLoad(object sender, EventArgs e) {
            obrotyParams = dc.Context[typeof(ObrotyParams), false] as ObrotyParams;
            checkObrotyPars(obrotyParams);                    
            ReportHeader.Title += WydrukiTools.WydrukiStanyMagazynoweLista.FilterInfo(obrotyParams); ;
            smw = null;
            Grid.AllowPrepareView = false;
            licznik = 0;
        }
        
        protected void Grid_ItemsGet(object sender, ItemsGetEventArgs args) {
            if (args.Deep != 1) return;
            Towar towar = (Towar)args.Row;

            if (smw == null)
                smw = (StanMagazynuWorker)
					dc.Context.CreateObject(null, typeof(StanMagazynuWorker), towar);
            else
                smw.Towar = towar;
            ArrayList list = new ArrayList();

            Quantity stanRazem = Quantity.Zero;
            decimal wartośćRazem = 0;
            foreach (Magazyn magazyn in obrotyParams.Magazyny)
            {
                smw.Magazyn = magazyn;
                Quantity stan = smw.StanMagazynu;
                if (!stan.IsZero) {
                    list.Add(new Rekord(magazyn.ToString(), stan, smw.WartośćMagazynu, towar));
                    stanRazem += stan;
                    wartośćRazem += smw.WartośćMagazynu;
                }
            }

            _StanRazem += stanRazem.Value;
            _WartośćRazem += wartośćRazem;

            if( list.Count > 1 ) {
                list.Insert( 0, new Rekord( "=== RAZEM ===", stanRazem, wartośćRazem, towar ) );
            }

            if (list.Count > 0) {
                Rekord rek = (Rekord)list[0];
                rek.Kod = towar.Kod;
                rek.Nazwa = towar.Nazwa;
                rek.lp = ++licznik;
            }

            args.Enumerable = list;
            StanRazem.EditValue = "Stan razem: " + _StanRazem;
            WartośćRazem.EditValue = "Wartość razem: " + new Currency( _WartośćRazem ); //.ToString();
        }

        protected void Grid_BeforeRow(object sender, RowEventArgs args) {
            Rekord rek = (Rekord)args.Row;
            if (rek.Nazwa != "")
            {
                colStan.Format = "<b>{0}</b>";
                colWartość.Format = "<b>{0:n}</b>";
                colCena.Format = "<b>{0:n}</b>";
            }
            else
            {
                colStan.Format = "";
                colWartość.Format = "{0:n}";
                colCena.Format = "{0:n}";
            }
        }

        private void checkObrotyPars(ObrotyParams pars) {
            if (pars == null)
                throw new ArgumentNullException("ObrotyParams pars");
            if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
                throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
        }
	    
</script>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Stany magazynowe|</STRONG>" runat="server"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" OnItemsGet="Grid_ItemsGet" OnBeforeRow="Grid_BeforeRow">
				<Columns>
                    <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="LP" Width="5"></ea:GridColumn>
					<ea:GridColumn Width="18" Align="Left" DataMember="Kod" Caption="Towar~Kod" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Nazwa" Caption="Towar~Nazwa" runat="server" EncodeHTML="True"></ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="Magazyn" Width="18" EncodeHTML="True"></ea:GridColumn>
                    <ea:GridColumn Width="14" Align="Right" DataMember="Stan" Caption="Ilość" runat="server" ID="colStan"></ea:GridColumn>
                    <ea:GridColumn Width="14" Align="Right" DataMember="CenaSrednia" Caption="Cena~średnia" Format="{0:n}" runat="server" ID="colCena"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" DataMember="Wartość" Caption="Wartość" Format="{0:n}" runat="server" ID="colWartość"></ea:GridColumn>
				</Columns>
			</ea:Grid>
            <br />
            <ea:DataLabel runat="server" ID="StanRazem" /><br />
            <ea:DataLabel runat="server" ID="WartośćRazem" />
			<eb:ReportFooter id="ReportFooter" runat="server"  PrintDate="true" PrintTime="true"></eb:ReportFooter>
		</form>
	</body>
</HTML>

